/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.plants.BlockShortGrassTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenLooseRocks;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class RegenRocksSticks
extends WorldGenLooseRocks {
    public RegenRocksSticks(boolean generateOres) {
        super(generateOres);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator instanceof ChunkGenTFC && world.field_73011_w.getDimension() == 0) {
            BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            ChunkDataTFC baseChunkData = ChunkDataTFC.get(world, chunkBlockPos);
            HashSet veins = Sets.newHashSet();
            int xoff = chunkX * 16 + 8;
            int zoff = chunkZ * 16 + 8;
            if (this.generateOres) {
                ChunkDataTFC[] chunkData = new ChunkDataTFC[]{baseChunkData, ChunkDataTFC.get(world, chunkBlockPos.func_177982_a(16, 0, 0)), ChunkDataTFC.get(world, chunkBlockPos.func_177982_a(0, 0, 16)), ChunkDataTFC.get(world, chunkBlockPos.func_177982_a(16, 0, 16))};
                if (!chunkData[0].isInitialized()) {
                    return;
                }
                int lowestYScan = Math.max(10, world.func_175672_r(chunkBlockPos).func_177956_o() - ConfigTFC.General.WORLD.looseRockScan);
                for (ChunkDataTFC data : chunkData) {
                    veins.addAll(data.getGeneratedVeins());
                }
                if (!veins.isEmpty()) {
                    veins.removeIf(v -> v.getType() == null || !v.getType().hasLooseRocks() || v.getHighestY() < lowestYScan);
                }
            }
            int i = 0;
            while ((double)i < (double)ConfigTFC.General.WORLD.looseRocksFrequency * this.factor) {
                BlockPos pos = new BlockPos(xoff + random.nextInt(16), 0, zoff + random.nextInt(16));
                Rock rock = baseChunkData.getRock1(pos);
                this.generateRock(world, pos.func_177981_b(world.func_175672_r(pos).func_177956_o()), this.getRandomVein(Arrays.asList(veins.toArray(new Vein[0])), pos, random), rock);
                ++i;
            }
        }
    }

    @Override
    protected void generateRock(World world, BlockPos pos, @Nullable Vein vein, Rock rock) {
        if (RegenRocksSticks.isReplaceable(world, pos).booleanValue()) {
            super.generateRock(world, pos, vein, rock);
        }
    }

    private static Boolean isReplaceable(World world, BlockPos pos) {
        Block test = world.func_180495_p(pos).func_177230_c();
        return test instanceof BlockShortGrassTFC || test.isAir(world.func_180495_p(pos), (IBlockAccess)world, pos);
    }
}

